
// ICS_Sites.js
//
//     Created:  2004.10.08
//    Requires:  ICS_setup.js
// Description:  Instruments the http://support.intel.com/support/ static content websites
//				 for SiteCatalyst web analytics.

//
// Conventions for the majority of sites
//

var wa_geo = "unassigned";
var wa_language = metatagsObj['language'] || "unassigned";
var wa_org1 = "supp";												// Support
var wa_org2 = "sites";												// Sites
var wa_org3 = pathObj.dir[1] || "unassigned";				     	// Family category:  2nd directory in path
var wa_org4 = pathObj.dir[pathObj.dir.length - 1] || "unassigned";  // Product category:  last directory in path. 
var wa_orgX = location.pathname.toLowerCase();	                  	// last hierarchy variable:  the URL's full path.
var wa_reportSuites = "intelcorpsupp";								// WAP 1.1 feature

// use the URL's full path as our page name,
var wa_pageName = location.pathname.toLowerCase();
wa_pageName = Exceptions(wa_pageName)

function Exceptions(pageName){
	// The /sites/ and the /jp/ root directories must set different org2 variables and
	// then apply rules one level lower
	if(pathObj.dir[0]){
		switch(pathObj.dir[0].toLowerCase()){
			// The sites directory should map as if it were support
			case("sites"):{
				wa_org3 = pathObj.dir[2] || "unassigned";
				wa_orgX = wa_orgX.substring(6,255);
				pageName = wa_orgX;
				if(wa_org4 == "support"){
					wa_org4 = "unassigned";
				}
				break;
			}
			// The Japan site does not follow the pattern.  It is /jp/support/ instead
			// of /support/jp/ like the other languages, so use a different parameter.
			case("jp"):{
				wa_org2 = "IJKK";
				wa_org3 = pathObj.dir[2] || "unassigned";
				if(wa_org4 == "support"){
					wa_org4 = "unassigned";
				}
				break;
			}			
		}
	}


	// Handle a special case: 
	// http://support.intel.com, www.intel.com/support, support.intel.com/support, 
	// support.intel.com/index.htm, support.intel.com/sites/, support.intel.com/sites/support/,
	// and support.intel.com/sites/support/index.htm should all be mapped to /support/
	if(pageName == "/" || pageName == "/sites/" || pageName == "/sites/support/" ||  pageName == "/sites/support/index.htm" || pageName == "" ){
		pageName = "/support/";
	}  

	// Capture all index pages as index.htm.
	// e.g. /support/chipsets/ should be renamed to /support/chipsets/index.htm

	if ((pageName.indexOf(".") > -1) && (pageName.charAt(pageName.length-1) === "/")) {
		pageName = pageName.substring(0,pageName.length-1);
	}
	else {
		pageName = pageName.replace(/(\/)$/, "/index.htm");
	}

	wa_orgX = pageName;

	// Remove the root "/" and replace with a space.  We do this so 
	// the report page name will show up as e.g. supp: support/chipsets/index.htm
	pageName = pageName.replace(/^\//, " "); 


	// Some files are stored in "sb" subfolders.  Ignore these and look one level up.
	if(wa_org4 == "sb"){
		wa_org4 = pathObj.dir[pathObj.dir.length - 2];
	}

	// For /support/motherboards/ the Family category is the 3rd, not 2nd, 
	// directory in the path (when a 3rd directory exists)
	if(pathObj.dir[1] != undefined) {
		if(pathObj.dir[1].toLowerCase() == "motherboards" && pathObj.dir[2]) {
			wa_org3 = pathObj.dir[2];				
		}
	}
	
	// Some top-level pages have no Product category,
	// e.g.	/support/chipsets/
	if(wa_org3 == wa_org4) {
		wa_org4 = "unassigned";  
	}
	
	// Never use "sb" as one of the values
	if(wa_org3 == "sb"){
		wa_org3 = "unassigned";
	}

	// Some top-level pages have neither a Product nor Family category.
	// e.g.	/support/feedback.htm 
	if(pathObj.dir.length < 2) {
		wa_org3 = "unassigned";   
		wa_org4 = "unassigned";  
	}
	
	// Hard code certain URLs to specific values
	if(pathObj.dir[1]){
		switch(pathObj.dir[1].toLowerCase()){
			case("dayna"):{
				wa_org3 = "network";
				wa_org4 = "dayna";
				break;
			}				
			case("remotemgt"):{
				wa_org3 = "network";
				wa_org4 = "remotemgt";
				break;
			}			
			case("express"):{
				wa_org3 = "network";
				break;			
			}			
			case("storageexpress"):{
				wa_org3 = "network";
				wa_org4 = "storageexpress";
				break;		
			}
		}
	}
	
	// If wa_orgX exceeds the 80 character limit, left-truncate.
	if(wa_orgX.length > 80){
		wa_orgX = wa_orgX.substring(wa_orgX.length-80, wa_orgX.length);
	}
	
	return pageName;
}